# Affiliate Travel Door-to-Door - Lightweight PHP/MySQL Starter
This project is a minimal, self-contained starter for an affiliate travel site with:
- Public landing page with editable content + affiliate registration form
- Member area (login via name or WhatsApp + password)
- Admin area to view users and process withdraws
- Integration examples for WhatsApp API via fonnte.com and sending email via PHP `mail()`

**Important**
- Edit `config.php` to set your MySQL database credentials and Fonnte API key/phone.
- Run the SQL in `sql/schema.sql` to create the tables.
- Run `create_admin.php` once (open it in browser) to create default admin (username `fcryHokBat`, password `3rf4n#FCRY`).
- This code is intentionally simple to be easy to adapt. Sanitize/secure more for production (CSRF, rate-limits, prepared statements are used via PDO).

Files:
- /public/index.php        (landing + registration form)
- /public/register_process.php
- /public/login.php
- /public/member.php
- /public/withdraw.php
- /public/admin.php
- /public/approve_withdraw.php
- /public/logout.php
- config.php
- db.php
- functions.php
- create_admin.php
- sql/schema.sql
