<?php
// functions.php - helpers
function generate_affiliate_code($pdo) {
  do {
    $code = 'ME-' . strtoupper(substr(bin2hex(random_bytes(3)),0,6));
    $stmt = $pdo->prepare('SELECT id FROM users WHERE affiliate_code = ?');
    $stmt->execute([$code]);
  } while ($stmt->fetch());
  return $code;
}

function send_whatsapp_fonnte($to_number, $message) {
  $cfg = require __DIR__.'/config.php';
  if (empty($cfg->fonnte_api_key) || empty($cfg->fonnte_phone_id)) return false;

  // Example cURL to fonnte.com API (adjust per their docs)
  $url = 'https://api.fonnte.com/v1/messages';
  $payload = json_encode([
    'phone_id' => $cfg->fonnte_phone_id,
    'to' => $to_number,
    'type' => 'text',
    'text' => [ 'body' => $message ]
  ]);

  $ch = curl_init($url);
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'Authorization: Bearer '.$cfg->fonnte_api_key
  ]);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
  $res = curl_exec($ch);
  $err = curl_error($ch);
  curl_close($ch);
  if ($err) return false;
  return $res;
}

function send_email($to, $subject, $body) {
  $cfg = require __DIR__.'/config.php';
  $headers = 'From: ' . $cfg->from_email . "\r\n" .
             'Reply-To: ' . $cfg->from_email . "\r\n" .
             'Content-Type: text/html; charset=UTF-8';
  return mail($to, $subject, $body, $headers);
}
