<?php
session_start();
require __DIR__.'/../db.php';
if (empty($_SESSION['user_id']) || empty($_SESSION['is_admin'])) {
  header('Location: login.php'); exit;
}
// simple admin panel to list users and withdraws
$users = $pdo->query('SELECT * FROM users ORDER BY created_at DESC')->fetchAll(PDO::FETCH_ASSOC);
$withdraws = $pdo->query('SELECT w.*, u.name, u.whatsapp FROM withdraws w JOIN users u ON w.user_id = u.id ORDER BY w.created_at DESC')->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html><html>
<head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Admin Panel</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body>
<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
  <div class="container">
    <a class="navbar-brand" href="#">Admin</a>
    <div><a class="btn btn-outline-light btn-sm" href="logout.php">Logout</a></div>
  </div>
</nav>
<div class="container py-4">
  <div class="row">
    <div class="col-md-6">
      <div class="card card-body mb-3">
        <h5>Daftar Afiliasi</h5>
        <table class="table table-sm"><thead><tr><th>Nama</th><th>WA</th><th>Kode</th><th>Saldo</th></tr></thead><tbody>
        <?php foreach($users as $u): ?>
          <tr>
            <td><?=htmlspecialchars($u['name'])?></td>
            <td><?=htmlspecialchars($u['whatsapp'])?></td>
            <td><?=htmlspecialchars($u['affiliate_code'])?></td>
            <td>Rp <?=number_format($u['balance'],0,',','.')?></td>
          </tr>
        <?php endforeach;?>
        </tbody></table>
      </div>
    </div>
    <div class="col-md-6">
      <div class="card card-body">
        <h5>Permintaan Withdraw</h5>
        <table class="table table-sm"><thead><tr><th>ID</th><th>User</th><th>Jumlah</th><th>Fee</th><th>Status</th><th>Aksi</th></tr></thead>
        <tbody>
        <?php foreach($withdraws as $w): ?>
          <tr>
            <td><?=$w['id']?></td>
            <td><?=htmlspecialchars($w['name'])?><div class="small"><?=htmlspecialchars($w['whatsapp'])?></div></td>
            <td>Rp <?=number_format($w['amount'],0,',','.')?></td>
            <td>Rp <?=number_format($w['fee'],0,',','.')?></td>
            <td><?=$w['status']?></td>
            <td>
              <?php if($w['status']=='pending'): ?>
                <form method="post" action="approve_withdraw.php" style="display:inline">
                  <input type="hidden" name="id" value="<?=$w['id']?>">
                  <button name="action" value="approved" class="btn btn-sm btn-success">Approve</button>
                  <button name="action" value="rejected" class="btn btn-sm btn-danger">Reject</button>
                </form>
              <?php else: echo $w['status']; endif; ?>
            </td>
          </tr>
        <?php endforeach;?>
        </tbody></table>
      </div>
    </div>
  </div>
</div>
</body></html>
