<?php
session_start();
require __DIR__.'/../db.php';
require __DIR__.'/../functions.php';
if (empty($_SESSION['user_id']) || empty($_SESSION['is_admin'])) { header('Location: login.php'); exit; }
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { header('Location: admin.php'); exit; }
$id = (int)($_POST['id'] ?? 0);
$action = $_POST['action'] ?? '';
if (!$id) { header('Location: admin.php'); exit; }
$stmt = $pdo->prepare('SELECT w.*, u.whatsapp, u.name FROM withdraws w JOIN users u ON w.user_id = u.id WHERE w.id=?');
$stmt->execute([$id]); $w = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$w) { header('Location: admin.php'); exit; }
if ($action === 'approved') {
  $stmt = $pdo->prepare('UPDATE withdraws SET status="approved", processed_at=NOW() WHERE id=?');
  $stmt->execute([$id]);
  // notify user
  send_whatsapp_fonnte($w['whatsapp'], "Withdraw Anda (ID: {$id}) telah disetujui. Jumlah: Rp {$w['amount']}");
} else {
  // if rejected, return balance to user
  $pdo->prepare('UPDATE withdraws SET status="rejected", processed_at=NOW() WHERE id=?')->execute([$id]);
  // refund
  $pdo->prepare('UPDATE users SET balance = balance + ? WHERE id = ?')->execute([$w['amount'],$w['user_id']]);
  send_whatsapp_fonnte($w['whatsapp'], "Withdraw Anda (ID: {$id}) ditolak dan saldo telah dikembalikan.");
}
header('Location: admin.php');
exit;
