<?php
require __DIR__.'/../db.php';
require __DIR__.'/../functions.php';
// Editable content: in a simple file or you can make admin edit later
$page_title = 'Program Afiliasi Travel Door-to-Door';
$content = "<p>Selamat datang di program afiliasi travel door-to-door. Daftarkan diri Anda untuk mulai mendapatkan komisi untuk setiap pemesanan.</p>";
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title><?=htmlspecialchars($page_title)?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
  <div class="container">
    <a class="navbar-brand" href="#">Afiliasi Travel</a>
    <div>
      <a class="btn btn-light btn-sm" href="login.php">Login</a>
    </div>
  </div>
</nav>
<div class="container py-4">
  <div class="row">
    <div class="col-md-7">
      <h1><?=htmlspecialchars($page_title)?></h1>
      <div class="card mb-3">
        <div class="card-body">
          <?= $content ?>
        </div>
      </div>
      <h4>Form Pendaftaran Afiliasi</h4>
      <form action="register_process.php" method="post" class="card card-body">
        <h5>Data User</h5>
        <div class="mb-2">
          <label class="form-label">Nama</label>
          <input name="name" required class="form-control">
        </div>
        <div class="mb-2">
          <label class="form-label">Nomor Whatsapp</label>
          <input name="whatsapp" required class="form-control" placeholder="628xx..." >
        </div>
        <div class="mb-2">
          <label class="form-label">Alamat Lengkap</label>
          <textarea name="address" class="form-control"></textarea>
        </div>
        <div class="mb-2">
          <label class="form-label">Email</label>
          <input name="email" type="email" class="form-control">
        </div>
        <div class="mb-2">
          <label class="form-label">Password Login</label>
          <input name="password" type="password" required class="form-control">
        </div>
        <h5 class="mt-3">Data Bank</h5>
        <div class="mb-2">
          <label class="form-label">Nama Bank</label>
          <input name="bank_name" class="form-control">
        </div>
        <div class="mb-2">
          <label class="form-label">Nama Pemilik Bank</label>
          <input name="bank_owner" class="form-control">
        </div>
        <div class="mb-2">
          <label class="form-label">Nomor Rekening</label>
          <input name="bank_number" class="form-control">
        </div>
        <div class="small text-muted mt-2">*semua transaksi withdraw akan dikenakan biaya transfer sesuai bank masing-masing</div>
        <div class="mt-3">
          <button class="btn btn-primary">Daftar Sekarang</button>
        </div>
      </form>
    </div>
    <div class="col-md-5">
      <div class="card card-body">
        <h5>Informasi Singkat</h5>
        <p>Halaman ini bersifat statis. Untuk mengubah konten, edit file <code>public/index.php</code> atau simpan konten ke database dan buat admin editor.</p>
      </div>
    </div>
  </div>
</div>
</body>
</html>
