<?php
session_start();
require __DIR__.'/../db.php';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $u = trim($_POST['user'] ?? '');
  $pw = $_POST['password'] ?? '';
  if ($u === '' || $pw === '') { $err = 'Masukkan kredensial.'; }
  else {
    $stmt = $pdo->prepare('SELECT * FROM users WHERE (name = ? OR whatsapp = ?) LIMIT 1');
    $stmt->execute([$u,$u]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    if ($user && password_verify($pw, $user['password'])) {
      $_SESSION['user_id'] = $user['id'];
      $_SESSION['is_admin'] = (bool)$user['is_admin'];
      header('Location: ' . ($_SESSION['is_admin']? 'admin.php' : 'member.php'));
      exit;
    } else $err = 'Kredensial salah.';
  }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<div class="container py-5">
  <div class="row justify-content-center">
    <div class="col-md-6">
      <div class="card card-body">
        <h4>Login</h4>
        <?php if (!empty($_GET['registered'])): ?><div class="alert alert-success">Pendaftaran berhasil. Silakan login.</div><?php endif;?>
        <?php if (!empty($err)): ?><div class="alert alert-danger"><?=htmlspecialchars($err)?></div><?php endif;?>
        <form method="post">
          <div class="mb-2">
            <label class="form-label">Nama atau Nomor Whatsapp</label>
            <input name="user" class="form-control" required>
          </div>
          <div class="mb-2">
            <label class="form-label">Password</label>
            <input name="password" type="password" class="form-control" required>
          </div>
          <div class="d-flex gap-2">
            <button class="btn btn-primary">Login</button>
            <a class="btn btn-secondary" href="index.php">Kembali</a>
          </div>
        </form>
      </div>
    </div>
  </div>
</div>
</body></html>
