<?php
session_start();
require __DIR__.'/../db.php';
if (empty($_SESSION['user_id']) || !empty($_SESSION['is_admin'])) {
  header('Location: login.php');
  exit;
}
$uid = (int)$_SESSION['user_id'];
$stmt = $pdo->prepare('SELECT * FROM users WHERE id = ?');
$stmt->execute([$uid]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);
// fetch earnings & withdraws
$earn = $pdo->prepare('SELECT * FROM earnings WHERE user_id=? ORDER BY created_at DESC');
$earn->execute([$uid]);
$earnings = $earn->fetchAll(PDO::FETCH_ASSOC);
$wd = $pdo->prepare('SELECT * FROM withdraws WHERE user_id=? ORDER BY created_at DESC');
$wd->execute([$uid]);
$withdraws = $wd->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html><html>
<head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Member Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head><body class="bg-light">
<nav class="navbar navbar-expand-lg navbar-dark bg-success">
  <div class="container">
    <a class="navbar-brand" href="#">Member</a>
    <div><a class="btn btn-light btn-sm" href="logout.php">Logout</a></div>
  </div>
</nav>
<div class="container py-4">
  <div class="row">
    <div class="col-md-4">
      <div class="card card-body">
        <h5><?=htmlspecialchars($user['name'])?></h5>
        <div><strong>WA:</strong> <?=htmlspecialchars($user['whatsapp'])?></div>
        <div><strong>Kode:</strong> <?=htmlspecialchars($user['affiliate_code'])?></div>
        <div><strong>Saldo:</strong> Rp <?=number_format($user['balance'],0,',','.')?></div>
      </div>
      <div class="card card-body mt-3">
        <h6>Ajukan Withdraw</h6>
        <form method="post" action="withdraw.php">
          <div class="mb-2"><label>Jumlah (minimal Rp 50.000)</label>
          <input name="amount" type="number" min="50000" required class="form-control"></div>
          <div><button class="btn btn-primary">Ajukan</button></div>
        </form>
      </div>
    </div>
    <div class="col-md-8">
      <div class="card card-body mb-3">
        <h6>Laporan Penghasilan</h6>
        <?php if(!$earnings): ?><div class="text-muted">Belum ada penghasilan.</div><?php else { ?>
        <table class="table table-sm">
          <thead><tr><th>Tanggal</th><th>Deskripsi</th><th>Jumlah</th></tr></thead>
          <tbody>
          <?php foreach($earnings as $e): ?>
            <tr><td><?=$e['created_at']?></td><td><?=htmlspecialchars($e['description'])?></td><td>Rp <?=number_format($e['amount'],0,',','.')?></td></tr>
          <?php endforeach;?>
          </tbody>
        </table>
        <?php } ?>
      </div>
      <div class="card card-body">
        <h6>Riwayat Withdraw</h6>
        <?php if(!$withdraws): ?><div class="text-muted">Belum ada withdraw.</div><?php else { ?>
        <table class="table table-sm">
          <thead><tr><th>Tgl</th><th>Jumlah</th><th>Fee</th><th>Status</th></tr></thead>
          <tbody>
          <?php foreach($withdraws as $w): ?>
            <tr>
              <td><?=$w['created_at']?></td>
              <td>Rp <?=number_format($w['amount'],0,',','.')?></td>
              <td>Rp <?=number_format($w['fee'],0,',','.')?></td>
              <td><?=$w['status']?></td>
            </tr>
          <?php endforeach;?>
          </tbody>
        </table>
        <?php } ?>
      </div>
    </div>
  </div>
</div>
</body></html>
