<?php
require __DIR__.'/../db.php';
require __DIR__.'/../functions.php';
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header('Location: index.php');
  exit;
}
$name = trim($_POST['name'] ?? '');
$whatsapp = trim($_POST['whatsapp'] ?? '');
$address = trim($_POST['address'] ?? '');
$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$bank_name = trim($_POST['bank_name'] ?? '');
$bank_owner = trim($_POST['bank_owner'] ?? '');
$bank_number = trim($_POST['bank_number'] ?? '');

if (!$name || !$whatsapp || !$password) {
  die('Nama, Whatsapp, dan Password wajib diisi.');
}
// generate affiliate code
$code = generate_affiliate_code($pdo);
$pw = password_hash($password, PASSWORD_DEFAULT);
$stmt = $pdo->prepare('INSERT INTO users (name, whatsapp, address, email, password, affiliate_code, bank_name, bank_owner, bank_number) VALUES (?,?,?,?,?,?,?,?,?)');
$stmt->execute([$name,$whatsapp,$address,$email,$pw,$code,$bank_name,$bank_owner,$bank_number]);
$user_id = $pdo->lastInsertId();

// send whatsapp to admin & affiliate via fonnte (best-effort)
$msg = "Pendaftaran Afiliasi Baru:\nNama: {$name}\nWA: {$whatsapp}\nKode: {$code}\nEmail: {$email}";
$cfg = require __DIR__.'/../config.php';
// to admin
if (!empty($cfg->admin_whatsapp)) {
  send_whatsapp_fonnte($cfg->admin_whatsapp, $msg);
}
// to affiliate
send_whatsapp_fonnte($whatsapp, "Terima kasih sudah daftar. Kode afiliasi Anda: {$code}");
// send email to affiliate
if ($email) {
  send_email($email, 'Pendaftaran Afiliasi Berhasil', '<p>Terima kasih telah mendaftar. Kode afiliasi Anda: <strong>'.$code.'</strong></p>');
}

header('Location: login.php?registered=1');
exit;
