<?php
session_start();
require __DIR__.'/../db.php';
require __DIR__.'/../functions.php';
if (empty($_SESSION['user_id']) || !empty($_SESSION['is_admin'])) {
  header('Location: login.php'); exit;
}
$uid = (int)$_SESSION['user_id'];
if ($_SERVER['REQUEST_METHOD'] !== 'POST') { header('Location: member.php'); exit; }
$amount = (float)($_POST['amount'] ?? 0);
if ($amount < 50000) { die('Minimal withdraw Rp 50.000'); }
// load user
$stmt = $pdo->prepare('SELECT * FROM users WHERE id=?');
$stmt->execute([$uid]); $user = $stmt->fetch(PDO::FETCH_ASSOC);
if (!$user) die('User tidak ditemukan');
if ($amount > (float)$user['balance']) die('Saldo tidak cukup.');
// simple fee: leave to admin bank; here we store fee = 0 and admin can set later. For demo assume fee = 0.01 * amount
$fee = round($amount * 0.01,2);
$stmt = $pdo->prepare('INSERT INTO withdraws (user_id, amount, fee) VALUES (?,?,?)');
$stmt->execute([$uid,$amount,$fee]);
$wid = $pdo->lastInsertId();
// subtract balance immediately
$newbal = $user['balance'] - $amount;
$upd = $pdo->prepare('UPDATE users SET balance=? WHERE id=?');
$upd->execute([$newbal,$uid]);
// notify admin & user
$cfg = require __DIR__.'/../config.php';
$msg = "Permintaan Withdraw:\nUser: {$user['name']}\nJumlah: Rp {$amount}\nFee: Rp {$fee}\nID: {$wid}";
if (!empty($cfg->admin_whatsapp)) send_whatsapp_fonnte($cfg->admin_whatsapp, $msg);
send_whatsapp_fonnte($user['whatsapp'], "Pengajuan withdraw diterima. Kami akan memproses. Jumlah: Rp {$amount} (fee Rp {$fee})");
header('Location: member.php');
exit;
